$( document ).ready(function() {
   
    var tileSize            = 96;
    var tileSpacing         = 10;
    var tilesArray          = [];
    var selectedArray       = [];
    var playSound;
    var tilesLeft;
    var intro;
    var music;
    var end_music;
    
    //var game        = new Phaser.Game(800, 600, Phaser.AUTO, 'game');
    var game            = new Phaser.Game(800, 600);
    
    var boot            = function(game){};
    var preloader       = function(game){};
    var play_game       = function(game){};
    var title_screen    = function(game){};
    var end_game        = function(game){};
    
    /*********************************************************
     *
     *
     *
     *********************************************************/
    
    boot.prototype =
    {

        init: function ()
        {
            game.scale.pageAlignHorizontally = true;
            game.scale.pageAlignVertically = true;
            game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            game.stage.disableVisibilityChange = true;
        },
    
        preload: function ()
        {
            game.load.image("background", "assets/images/background.jpg");
            game.load.image("logo", "assets/images/logo.png");
            game.load.image("loading", "assets/images/loading.png");
        },
    
        create: function ()
        {
            game.state.start('preloader');
        }
    
    };
    
    
    preloader.prototype =
    {
        preload: function()
        {
            //game.add.sprite(0, 0, 800, 600, "background");
            this.background = this.add.sprite(0, 0, 'background');
           
            this.logo = this.add.sprite(this.world.width/2, this.world.height/2 - 100, 'logo');
            this.logo.anchor.set(0.5, 0.5);
            
            this.loading = this.add.sprite(this.world.width/2, this.world.height/2, 'loading');
            this.loading.anchor.set(0.5, 0.5);
          
            game.load.audio("intro", ["assets/sounds/intro.mp3"]);
            game.load.image("play", "assets/images/play.png");
            game.load.image("img_easy", "assets/images/easy.png");
            game.load.image("img_medium", "assets/images/medium.png");
            game.load.image("img_hard", "assets/images/hard.png");
            game.load.spritesheet("img_sound", "assets/images/sound.png", 96, 96);
            
            game.load.audio("music", ["assets/sounds/play_music.mp3"]);
            game.load.image("background2", "assets/images/background2.jpg"); 
            game.load.image("home1", "assets/images/home1.png"); 
            game.load.spritesheet("animals", "assets/images/animals.png", tileSize, tileSize);
            game.load.audio("animal_0", ["assets/sounds/bird.mp3"]);
            game.load.audio("animal_1", ["assets/sounds/cat.mp3"]);
            game.load.audio("animal_2", ["assets/sounds/chicken.mp3"]);
            game.load.audio("animal_3", ["assets/sounds/pig.mp3"]);
            game.load.audio("animal_4", ["assets/sounds/cow.mp3"]);
            game.load.audio("animal_5", ["assets/sounds/dog.mp3"]);
            game.load.audio("animal_6", ["assets/sounds/duck.mp3"]);
            game.load.audio("animal_7", ["assets/sounds/sheep.mp3"]);
            game.load.audio("animal_8", ["assets/sounds/frog.mp3"]);
            game.load.audio("animal_9", ["assets/sounds/grasskopper.mp3"]);
            game.load.audio("animal_10", ["assets/sounds/horse.mp3"]);
            
            game.load.audio("end_music", ["assets/sounds/end_music.mp3"]);
            game.load.image("background2", "assets/images/background2.jpg");
            game.load.image("home", "assets/images/home.png");
            game.load.image("msg_end", "assets/images/msg_end.png");
            game.load.spritesheet('rain', 'assets/images/rain.png', 17, 17);
    
        },
    
        create: function()
        {
            //A simple fade out effect
            this.game.time.events.add(Phaser.Timer.SECOND * 2.0, function()
            {
                var tween = this.add.tween(this.loading)
                    .to({alpha: 0}, 750, Phaser.Easing.Linear.none);
                  
                tween.onComplete.add(function() {
                      this.logo.destroy();
                      this.loading.destroy();
                      this.startGame();
                  }, this);
    
                tween.start();
            }, this);
        },
    
        startGame: function()
        {
            game.state.start('title_screen');
        },
    
    };
    
    
    /*********************************************************
     *
     *
     *
     *********************************************************/
    
    title_screen.prototype =
    {
        preload: function()
        {
        },
        
        create: function()
        {
            var bg = game.add.tileSprite(0, 0, 800, 600, "background");
            
            intro = game.add.audio("intro", 1);
            intro.loop = true;
            intro.play();
            
            var logo = game.add.tileSprite(game.width / 2, game.height / 2 - 100, 550, 74, "logo");
            logo.anchor.set(0.5);
            
            var easy_button = game.add.button(game.width / 2 - 150 , game.height / 2, "img_easy", this.startGame2, this);
            easy_button.anchor.set(0.5);
            
            var medium_button = game.add.button(game.width / 2, game.height / 2, "img_medium", this.startGame2, this);
            medium_button.anchor.set(0.5);
            
            var img_hard = game.add.button(game.width / 2 + 150 , game.height / 2, "img_hard", this.startGame2, this);
            img_hard.anchor.set(0.5);
            
            var soundButton = game.add.button(game.width / 2, game.height / 2 + 150, "img_sound", this.toggle_sound, this);
            soundButton.anchor.set(0.5);
            
        },
        
        startGame2: function(target)
        {
            if(target.key=="img_easy")
            {
                numRows = 2;
                numCols = 3;
            }
            else if(target.key=="img_medium")
            {
                numRows = 3;
                numCols = 4;
            }
            else if(target.key=="img_hard")
            {
                numRows = 4;
                numCols = 5;
            }
            
            intro.stop();
            game.state.start("play_game");
        },
        
        startGame: function(target)
        {
            if(target.frame == 0)
            {
                playSound = true;
            }
            else
            {
                playSound = false;
            }
            intro.stop();
            game.state.start("play_game");
        },
        
        toggle_sound: function(target)
        {
            if(target.frame == 0)
            {
                playSound = false;
                intro.stop();
                target.frame = 1;
            }
            else
            {
                playSound = true;
                intro.play();
                target.frame = 0;
            }
        }
    }
    
    /*********************************************************
     *
     *
     *
     *********************************************************/

    
    play_game.prototype =
    {
        create: function()
        {
            music = game.add.audio("music", 1);
            music.loop = true;
            music.play();
            
            var bg = game.add.tileSprite(0, 0, 800, 600, "background2");
            this.placeTiles();
            
            var home = game.add.button(game.width / 2 - 350 , game.height / 2 - 250, "home1", this.back, this);
            home.anchor.set(0.5);
            home.scale.setTo(0.4, 0.4);
          
        },
        
        placeTiles: function()
        {
            tilesLeft       = numRows * numCols;
            var leftSpace   = (game.width - (numCols * tileSize) - ((numCols - 1) * tileSpacing))/2;
            var topSpace    = (game.height - (numRows * tileSize) - ((numRows - 1) * tileSpacing))/2;
            
            for(var i = 0; i < numRows * numCols; i++)
            {
                tilesArray.push(Math.floor(i / 2));
            }
            
            for(i = 0; i < numRows * numCols; i++)
            {
                var from            = game.rnd.between(0, tilesArray.length-1);
                var to              = game.rnd.between(0, tilesArray.length-1);
                var temp            = tilesArray[from];
                tilesArray[from]    = tilesArray[to];
                tilesArray[to]      = temp;
            }
            
            for(i = 0; i < numCols; i++)
            {
                for(var j = 0; j < numRows; j++)
                {
                    var tile    = game.add.button(leftSpace + i * (tileSize +tileSpacing), topSpace + j * (tileSize + tileSpacing), "animals", this.showTile, this);
                    tile.frame  = 11;
                    tile.value  = tilesArray[j * numCols + i];
                }
            }
        },
        
        showTile: function(target)
        {
            if(selectedArray.length < 2 && selectedArray.indexOf(target) == -1)
            {
                target.frame = target.value;
                selectedArray.push(target);
                
                if(selectedArray.length == 2)
                {
                    game.time.events.add(Phaser.Timer.SECOND, this.checkTiles, this);
                }
            }
        },
        
        checkTiles: function()
        {
            if(selectedArray[0].value == selectedArray[1].value)
            {
                music.volume = 0.2;
                
                var gm = game.add.audio("animal_"+selectedArray[1].value, 1).play();
                gm.onStop.add(this.check_win, this);
                
                selectedArray[0].destroy();
                selectedArray[1].destroy();
                
            }
            else
            {
                selectedArray[0].frame = 11;
                selectedArray[1].frame = 11;
            }
            
            selectedArray.length = 0;
        },
        
        check_win: function()
        {
            tilesLeft -= 2;
            if(tilesLeft == 0)
            {
                music.stop();
                music.destroy();
                
                tilesArray              = [];
                selectedArray.length    = 0;
                
                game.state.start("end_game");
            }
            else
            {
                music.volume = 1;
            }
        },
        
        back: function()
        {
            music.stop();
            music.destroy();
            
            tilesArray              = [];
            selectedArray.length    = 0;
            
            game.state.start("title_screen");
        }
    }

    
    /****************************************************
     *
     *
     *
     ****************************************************/
    
    end_game.prototype =
    {
        preload: function()
        {
            
        },
        
        create: function()
        {
            intro.stop();
            
            var bg = game.add.tileSprite(0, 0, 800, 600, "background2");
            
            var emitter = game.add.emitter(game.world.centerX, 0, 400);

            emitter.width = game.world.width;
        
            emitter.makeParticles('rain');
        
            emitter.minParticleScale = 0.1;
            emitter.maxParticleScale = 0.5;
        
            emitter.setYSpeed(300, 500);
            emitter.setXSpeed(-5, 5);
        
            emitter.minRotation = 0;
            emitter.maxRotation = 0;
        
            emitter.start(false, 1600, 5, 0);
            
            end_music = game.add.audio("end_music", 1);
            end_music.play();
            
            var msg_end = game.add.tileSprite(game.width / 2, game.height / 2 - 100, 613, 109, "msg_end");
            msg_end.anchor.set(0.5);
            
            var back_button = game.add.button(game.width / 2, game.height / 2 + 100, "home", this.back, this);
            back_button.anchor.set(0.5);
        },
        
        back: function()
        {
            end_music.stop();
            end_music.destroy();
            game.state.start("title_screen");
        }
    }
    
    
    game.state.add("boot", boot);
    game.state.add("preloader", preloader);
    game.state.add("title_screen", title_screen);
    game.state.add("play_game", play_game);
    game.state.add("end_game", end_game);
    
    game.state.start("boot");
    
    $.backstretch("assets/images/main_background.jpg");
    
});